# Rust Setup

Install rust, see the getting started page here: https://www.rust-lang.org/learn/get-started

## Windows 10 (not WSL) 

* Install VS C++ Build tools (via vs_BuildTools.exe), including the Windows 10 API, C++ - https://visualstudio.microsoft.com/visual-cpp-build-tools/

* Install Rust via `rustup-init.exe`, this will check for the build tools and install the rust compiler (rustc, and tools like cargo and clippy).

Note: If you want to move the rust installation files, you can, but setting the environment variables before running the rust installer does not work.

Default installation will install them to `C:\Users\<Username>\.rustup` and `C:\Users\<Username>\.cargo`.  Move the `.rustup` and `.cargo` folders after installation to somewhere else, like `F:\Data\.rustup` and `F:\Data\.cargo` and set two environment variables `RUSTUP_HOME` and `CARGO_HOME` and set them to the new locations.  e.g. `RUSTUP_HOME` = `F:\Data\.rustup`, `CARGO_HOME` = `F:\Data\.cargo`

If you moved the `.cargo` folder, then you also need to modify your path as the path created by the installer will be wrong, given the example above the path should be changed from `C:\Users\Hydra\.cargo\bin`... to `%CARGO_HOME%\bin`

Open a new terminal (command prompt) and run:

`rustup toolchain list`

and it should result with something like:

```
stable-x86_64-pc-windows-msvc (default)
```

If no toolchains are listed, then the environment variables and or folders are wrong, the .rustup and .cargo folders contain the command line tools/binaries, documentation and other related files.  Simply creating new empty `.rustup` and `.cargo` folders and setting the environment variable to it will result in an empty toolchain list and the rustc and cargo tools responding with `rust no override and no default toolchain set`.

If you see a toolchain instealled then success!, now you can also check the versions of the rust compiler and cargo:

```
> rustc --version
rustc 1.54.0 (a178d0322 2021-07-26)

> cargo --version
cargo 1.54.0 (5ae8d74b3 2021-06-22)
```

References/Links:

Rust getting started - https://www.rust-lang.org/learn/get-started
Microsoft C++ Build Tools - https://visualstudio.microsoft.com/visual-cpp-build-tools/
The Rustup Book - https://rust-lang.github.io/rustup/installation/index.html
The Cargo Book - https://doc.rust-lang.org/cargo/getting-started/installation.html
